@extends ('admin.layouts.app')

@section ('title', 'Create Event')

@section('page-header')
    <h1>
        Gallery Management
        <small>Create Gallery</small>
    </h1>
@endsection
@push('after-scripts')

@endpush
@section('content')
    {{ Form::open(['route' => 'admin.gallery.store', 'role' => 'form', 'method' => 'post']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Create Gallery</h3>
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', 'Gallery Name') }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => 'Name Your Gallery']) }}
                </div><!--form group-->

                <div class="form-group">
                    {{ Form::label('gallery_images', 'Gallery Images') }}
                    <div class="gallery-image-row">
                        <div class="gallery-image-uploader" data-toggle="seshra-uploader" data-type="image" data-group="gallery" data-multiple="true">
                        <div class="gallery-uploader-box">
                        <i class="fas fa-image"></i><br>
                        <span class="gallery-uploader-text">Browse</span>
                        </div>
                        <input type="hidden" name="images" class="selected-files">
                        <input type="hidden" name="default_image" class="default-image">
                        </div>
                        <div class="file-preview"></div>
                    </div>
                </div>

            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.gallery.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')
@endpush
