<div class="card" id="{{$name}}{{$col}}{{$item}}">
    <div class="card-header with-border">
        <h3 class="card-title">Text Block [Title, Content, Image]</h3>
        <div class="card-tools float-right">
            @isset($page)
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-pid="{{$page->id}}" data-col="{{$col}}" data-item="{{$item}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @else
                <button type="button" class="btn btn-xs btn-danger delete-meta-item" data-col="{{$col}}" data-item="{{$item}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @endisset
        </div>
    </div>
    <div class="card-body">
        <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][type]" value="text_block_title_image">
        <div class="form-group">
            {{ Form::label('title', trans('validation.attributes.backend.page.title')) }}
            <input type="text" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][title]" class="form-control" value="{{$post['title'] ?? ''}}">
        </div>
        <div class="form-group">
            <label for="content">Content</label>
            <textarea class="seshra-text-editor" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][content]" data-min-height="300" data-image-submit-url="{{route('admin.image.upload')}}" data-format="true" data-image-group="blogs">{!! $post['content'] ?? '' !!}</textarea>
        </div>
        <div class="form-group">
            <label for="content">Image</label>
            <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="blogs">
                <div class="input-group-prepend">
                        <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                </div>
                <div class="form-control file-amount">Choose File</div>
                <input type="hidden" name="post_meta[{{ Str::slug(strtolower($name)) }}][{{$col}}][{{$item}}][featured_image]" class="selected-files" value="{{$post['featured_image'] ?? ''}}">
            </div>
            <div class="file-preview box sm">
            </div>
        </div>
    </div>
</div>
