<div class="card dynamic-block" id="{{ Str::slug(strtolower($name)) }}">
    <div class="card-header with-border">
        <h3 class="card-title">Block #{{ $loop->iteration ?? $block }}</h3>
        <div class="card-tools float-right">
            @isset($page)
                Sort: #{{$meta->sort}}
                <button type="button" class="btn btn-xs btn-secondary sort-meta-item" data-key="{{$name}}" data-pid="{{$page->id}}" data-sort="up" data-toggle="tooltip" data-placement="top" title="Move block up"><i class="fas fa-arrow-up"></i></button>
                <button type="button" class="btn btn-xs btn-secondary sort-meta-item" data-key="{{$name}}" data-pid="{{$page->id}}" data-sort="down" data-toggle="tooltip" data-placement="top" title="Move block down"><i class="fas fa-arrow-down"></i></button>
                <button type="button" class="btn btn-xs btn-danger delete-block-item" data-pid="{{$page->id}}" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @else
                <button type="button" class="btn btn-xs btn-danger delete-block-item" data-key="{{ Str::slug(strtolower($name)) }}"><i class="fa fa-trash"></i></button>
            @endisset
        </div>
    </div>
    <div class="card-body">
        <div class="row">
        @for($i = 1; $i <= $cols; $i++)
            <div class="col-md-{{$column}}">
                <div class="border p-3 dynamic-items-holder">
                    <div class="dynamic-block-items">
                        @isset($metaitem)
                            @php 
                                $col = $i;
                                $posts = $metaitem[$i] ?? [];
                            @endphp
                            @foreach($posts as $item => $post)
                                @if (isset($post['type']) && $post['type'] == 'title_block')
                                    @include('admin.dynamic_block.title_block')
                                @elseif (isset($post['type']) && $post['type'] == 'title_subtitle_block')
                                    @include('admin.dynamic_block.title_subtitle_block')
                                @elseif (isset($post['type']) && $post['type'] == 'text_block')
                                    @include('admin.dynamic_block.text_block')
                                @elseif(isset($post['type']) && $post['type'] == 'text_block_title')
                                    @include('admin.dynamic_block.text_block_title')
                                @elseif(isset($post['type']) && $post['type'] == 'text_block_title_image')
                                    @include('admin.dynamic_block.text_block_title_image')
                                @elseif(isset($post['type']) && $post['type'] == 'list_block')
                                    @include('admin.dynamic_block.list_block')
                                @endif
                            @endforeach                            
                        @endisset
                    </div>
                    @if(default_lang() == $lang)
                    <div class="text-center">
                        <div class="btn-group dropup">
                            <button type="button" class="btn btn-primary">
                                Add Block Item
                            </button>
                            <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu" data-item="{{(isset($posts) && count($posts) > 0) ? max(array_keys($posts))+1 : 1}}">
                                <a class="dropdown-item" href="#" data-type="title_block" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">Title</a>
                                <a class="dropdown-item" href="#" data-type="title_subtitle_block" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">Title & Subtitle</a>
                                <a class="dropdown-item" href="#" data-type="text_block" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">Text Block</a>
                                <a class="dropdown-item" href="#" data-type="text_block_with_title" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">Text Block [Title, Content]</a>
                                <a class="dropdown-item" href="#" data-type="text_block_with_title_and_image" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">Text Block [Title, Content, Image]</a>
                                <a class="dropdown-item" href="#" data-type="list_block" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">List Block [Title]</a>
                                {{-- <a class="dropdown-item" href="#" data-type="text_list_block_without_image" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">List Block [Title, Content]</a> --}}
                                {{-- <a class="dropdown-item" href="#" data-type="text_list_block_with_image" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">List Block [Title, Content, Image]</a> --}}
                                {{-- <a class="dropdown-item" href="#" data-type="list_block_with_title_image" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">List Block [Title, Image]</a> --}}
                                {{-- <a class="dropdown-item" href="#" data-type="list_block_with_title_image_url" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">List Block [Title, Image, Url]</a> --}}
                                {{-- <a class="dropdown-item" href="#" data-type="accordion_block" data-col="{{$i}}" data-cols="{{$cols}}" data-block="{{$block}}">Accordion Block</a> --}}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        @endfor
        </div>
    </div>
</div>
