@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.comment.deleted'))

@section('after-styles')
        <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('page-header')
    <h1>
        {{ trans('labels.backend.comment.management') }}
        <small>{{ trans('labels.backend.comment.deleted') }}</small>
    </h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.comment.deleted') }}</h3>

            <div class="card-tools float-right">
                <!-- Include your header buttons  -->
                @if($total_deleted_comments > 0)
                    <a href="#" id="empty_trash" class="btn btn-xs btn-danger">Empty Trash</a>
                @endif
                    {{ link_to_route('admin.comments.index', trans('menus.backend.comments.main'), [], ['class' => 'btn btn-primary btn-xs']) }}
            </div><!--card-tools float-right-->
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="comments-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>{{ trans('labels.backend.comment.comments') }}</th>
                        <th>{{ __('labels.backend.table.status') }}</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
<!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

    <script>
        $(function() {
                $('#comments-table').DataTable({
                    processing: true,
                    serverSide: true,
                    iDisplayLength: 25,
                    ajax: {
                        url: '{{ route("admin.comments.get") }}',
                        type: 'post',
                        data: {trashed: true, _token: Laravel.csrfToken}
                    },
                    columns: [
                        {data: 'id', name: 'id'},
                        {data: 'comment', name: 'comment'},
                        {data: 'status', name: 'status'},
                        {data: 'created_at', name: 'created_at'},
                        {data: 'actions', name: 'actions', searchable: false, sortable: false}
                    ],
                    order: [[0, "asc"]],
                    searchDelay: 500
                });

                $("body").on("click", "a[name='delete_comment_perm']", function(e) {
                        e.preventDefault();
                        var linkURL = $(this).attr("href");

                        Swal.fire({
                            title: "{{ trans('strings.backend.general.are_you_sure') }}",
                            text: "{{ trans('strings.backend.general.delete_confirm',['attribute'=>'comment']) }}",
                            showCancelButton: true,
                            confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                            cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                            type: 'warning'
                        }).then((result) => {
                            result.value && window.location.assign(linkURL);
                        });
                    });

                    $("body").on("click", "a[name='restore_comment']", function(e) {
                        e.preventDefault();
                        var linkURL = $(this).attr("href");
                        Swal.fire({
                            title: "{{ trans('strings.backend.general.are_you_sure') }}",
                            text: "{{ trans('strings.backend.general.restore_confirm',['attribute'=>'comment']) }}",
                            showCancelButton: true,
                            confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                            cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                            type: 'info'
                        }).then((result) => {
                            result.value && window.location.assign(linkURL);
                        });
                    });

                    $("body").on("click", "#empty_trash", function(e) {
                        e.preventDefault();
                        var linkURL = "{{route('admin.comments.empty.trash')}}";

                        Swal.fire({
                            title: "{{ trans('strings.backend.general.are_you_sure') }}",
                            text: "{{ trans('strings.backend.general.empty_trash_confirm',['attribute'=>'comment']) }}",
                            showCancelButton: true,
                            confirmButtonText: "{{ trans('strings.backend.general.continue') }}",
                            cancelButtonText: "{{ trans('buttons.general.cancel') }}",
                            type: 'warning'
                        }).then((result) => {
                            result.value && window.location.assign(linkURL);
                        });
                    });
            
        });
    </script>
@endpush
