@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.category.edit'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.category.management') }}
        <small>{{ trans('labels.backend.category.edit') }}</small>
    </h1>
@endsection

@section('after-styles')
<style>
</style>
@endsection

@section('content')
{{ Form::model($category, ['route' => ['admin.category.update', $category->id],'role' => 'form', 'id' => 'categoryForm', 'method' => 'put']) }}
        <input name="lang" type="hidden" value="{{$lang}}">
        <ul class="nav nav-tabs nav-fill border-light">
            @foreach (locales() as $locale)
                <li class="nav-item">
                    <a class="nav-link text-reset @if ($locale == $lang ) active @else bg-soft-dark border-light border-left-0 @endif py-3" href="{{ route('admin.category.edit', $category->id) }}?lang={{$locale}}">
                        <img src="{{ public_asset('images/flags/'.$locale.'.png') }}" height="11" class="mr-1">
                        <span>{{$locale}}</span>
                    </a>
                </li>
            @endforeach
        </ul>
        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">{{ trans('labels.backend.category.edit') }}</h3>
            </div><!-- /.card-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', trans('validation.attributes.backend.category.title')) }}
                    <input type="text" class="form-control" name="{{$lang}}[title]" value="{{$category->translate($lang)->title ?? $category->title}}" placeholder="{{trans('validation.attributes.backend.category.title')}}">
                </div><!--form control-->

                <div class="form-group">
                    {{ Form::label('slug', trans('validation.attributes.backend.category.slug')) }}
                    {{ Form::text('slug', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.backend.category.slug')]) }}
                </div><!--form control-->

                <div class="form-group">
                    {{ Form::label('description', trans('validation.attributes.backend.category.description')) }}
                    <textarea class="form-control" name="{{$lang}}[description]" placeholder="{{ trans('validation.attributes.backend.category.description')}}" size="30x5">{!! $category->translate($lang)->description !!}</textarea>
                </div><!--form control-->
                <div class="form-group">
                    {{ Form::label('parent', trans('validation.attributes.backend.category.parent')) }}
                    {{ Form::hidden('parent_id', null,['id' => 'parent_id']) }}
                    <div class="btn-group dropup" id="parentCategory">
                      <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <span id="categorySelected">{{$category->parent ? $category->parent->title : 'Select Parent'}}</span> <span class="caret"></span>
                      </button>
                      <ul class="dropdown-menu">
                         <li><a class="dropdown-item" href="0" data-title="None" id="parentLink">None</a></li>
                        @include('admin.category.hierarchy')
                      </ul>
                    </div>
                </div><!--form control-->

                <div class="form-group">
                    <label>Featured Image</label>
                    <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="category">
                        <div class="input-group-prepend">
                            <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                        </div>
                        <div class="form-control file-amount">Choose File</div>
                        <input type="hidden" name="media_id" value="{{$category->media_id}}" class="selected-files">
                    </div>
                    <div class="file-preview box sm">
                    </div>
                </div>
            </div><!-- /.card-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.category.create', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--float-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--float-right-->

                <div class="clearfix"></div>
            </div><!-- /.card-body -->
        </div><!--box-->

{{ Form::close() }}
@endsection

@push('after-scripts')
   <script>
    $(document).ready(function(){
        $('#parentCategory #parentLink').click(function(event) {
            event.preventDefault();
            var id = $(this).attr('href');
            var title = $(this).data('title');
            $('#parent_id').val(id);
            $('#categorySelected').html(title);
        });
    });
    </script>
@endpush