@extends ('admin.layouts.app')

@section ('title', 'Create Block')

@section('page-header')
    <h1>
        Blocks Management
        <small>Create Block</small>
    </h1>
@endsection

@section('content')

<div class="col-md-12">
    <div class="row">
        <div class="col-md-7">
        {{ Form::open(['route' => 'admin.block.store', 'role' => 'form', 'method' => 'post', 'id' => 'block-form']) }}
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Create Block</h3>

                    <div class="card-tools float-right">
                        <!-- Include your header buttons -->
                    </div><!--card-tools float-right-->
                </div><!-- /.card-header -->

                <div class="card-body">
                    <div class="form-group">
                        {{ Form::label('title', 'Title') }}
                        {{ Form::text('title', null, ['class' => 'form-control', 'id'=> 'block-title', 'placeholder' => 'Title', 'required']) }}
                    </div><!--form control-->
                    <input type="checkbox" name="show"> Show title
                    <div class="form-group">
                        {{ Form::label('identifier', 'Identifier') }}
                        {{ Form::text('slug', null, ['class' => 'form-control', 'id'=>'block-identifier', 'placeholder' => 'Identifier']) }}
                    </div><!--form control-->

                    <div class="form-group">
                        <label for="content">Content</label>
                        <textarea class="seshra-text-editor" name="content" data-min-height="300"
                            data-image-submit-url="{{ route('admin.image.upload') }}" data-format="true"
                            data-image-group="blogs">{!! old('content') !!}</textarea>
                    </div>
                    <div class="form-group">
                        <label>Status</label>
                        <select class="form-control" name="status">
                            <option value="1">Show</option>
                            <option value="0">Hide</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button type="button" class = 'btn btn-primary btn-md float-left' id="preview">Preview</button>
                        {{ Form::submit(trans('buttons.general.save'), ['class' => 'btn btn-success btn-md float-right']) }}
                    </div><!--form control-->
                    
                </div><!-- /.card-body -->
            </div><!--box-->
        {{ Form::close() }}
        </div>
        <div class="col-md-5">
            <div class="card">
                <div class="card-header with-border">
                    <h3 class="card-title">Block Demo</h3>

                    <div class="card-tools float-right">
                        <!-- Include your header buttons -->
                    </div><!--card-tools float-right-->
                </div><!-- /.card-header -->

                <div class="card-body" id="block-demo">
                    <p>Demo of block shows here...</p>
                </div>
            </div><!--box-->
        </div>
    </div>
</div>

@stop
@push('after-scripts')
   <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.8.2/tinymce.min.js"></script>
    {{ script('vendor/laravel-filemanager/js/stand-alone-button.js')}}
    <script>
    $(function () {
        tinymce.init({
            selector: '#c7678',
            plugins: "code,link",
            toolbar: "undo redo |  formatselect | bold italic backcolor link | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | code",
        });

            $('#preview').click(function(event) {
                var title = $('#block-title').val();
                var identifier = $('#block-identifier').val();
                var content = tinymce.get("c7678").getContent();
                $.ajax({
                    url: base_url+ '/admin/block/preview',
                    type: 'POST',
                    dataType: 'json',
                    data: {title: title,identifier: identifier,content:content},
                })
                .done(function(data) {
                    $('#block-demo').html(data);
                })
                .fail(function() {
                    console.log("error");
                })
                .always(function() {
                    console.log("complete");
                });
                
            });

        });

    </script>
@endpush
