@extends ('admin.layouts.app')

@section ('title', 'Application')


@section('after-styles')
    <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('page-header')
    <h1>
        View
        <small>Application</small>
    </h1>
@endsection


@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.blog.active') }}</h3>
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="#" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><input type="checkbox" name="select_all" id="select_all"></th>
                        <th>{{ trans('labels.backend.table.id') }}</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Position</th>
                        <th>Date</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach ($applications as $application)
                            <tr>
                                <td></td>
                                <td>{{$application->id}}</td>
                                <td>{{$application->fname}}</td>
                                <td>{{$application->lname}}</td>
                                <td>{{$application->email}}</td>
                                <td>{{$application->phone}}</td>
                                <td>{{$application->position}}</td>
                                <td>{{$application->created_at}}</td>
                                <td><a href="{{route('admin.application.view', $application->id)}}" class="btn btn-xs btn-success"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="View Application"></i></a> 
                                    <a href="{{ route('admin.application.delete', $application->id) }}"
                                        data-method="delete"
                                        data-trans-button-cancel="cancel"
                                        data-trans-button-confirm="delete"
                                        data-trans-title="Are you sure?"
                                        class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="delete"></i></a></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-center">
                    {!! $applications->links() !!}
                </div>
            </div><!--table-responsive-->
            
        </div><!-- /.card-body -->
    </div><!--box-->

@stop

@push('after-scripts')
    <!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

    <script>
        $(function() {
           var table = $('#applications-table').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 25,
                ajax: {
                    url: '{{ route("admin.application.get") }}',
                    type: 'get',
                    data: {trashed: false, _token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'select', name: 'select', searchable: false, sortable: false},
                    {data: 'id', name: 'id'},
                    {data: 'fname', name: 'fname'},
                    {data: 'lname', name: 'lname'},
                    {data: 'email', name: 'email'},
                    {data: 'phone', name: 'phone'},
                    {data: 'position', name: 'position'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[1, "desc"]],
                searchDelay: 500
            });

             // Handle click on "Select all" control
            $('#select_all').on('click', function(){
                // Get all rows with search applied
                var rows = table.rows({ 'search': 'applied' }).nodes();
                // Check/uncheck checkboxes for all rows in the table
                $('input[type="checkbox"]', rows).prop('checked', this.checked);
                if(!this.checked){
                    $('#delete_button').hide();
                    $('#selected_data div').html('');
                }else{
                    $('#delete_button').show();
                }
            });

            // Handle click on checkbox to set state of "Select all" control
            $('#applications-table tbody').on('change', 'input[type="checkbox"]', function(){
                // If checkbox is not checked
                if(!this.checked){
                    var el = $('#select_all').get(0);
                    // If "Select all" control is checked and has 'indeterminate' property
                    if(el && el.checked && ('indeterminate' in el)){
                        // Set visual state of "Select all" control
                        // as 'indeterminate'
                        el.indeterminate = true;
                    }
                    
                }
                $('#delete_button').show();
            });

        });
    </script>
    
@endpush