@extends ('admin.layouts.app')

@section ('title', trans('labels.backend.access.roles.management'))

@section('after-styles')
        <!-- DataTables -->
  {{ style('vendor/datatables-bs4/css/dataTables.bootstrap4.min.css') }}
  {{ style('vendor/datatables-responsive/css/responsive.bootstrap4.min.css') }}
@stop

@section('page-header')
    <h1>{{ trans('labels.backend.access.roles.management') }}</h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('labels.backend.access.roles.management') }}</h3>
            <div class="card-tools float-right">
                @include('admin.access.includes.partials.role-header-buttons')
            </div>
        </div><!-- /.card-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="roles-table" class="table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th>{{ trans('labels.backend.access.roles.table.role') }}</th>
                            <th>{{ trans('labels.backend.access.roles.table.permissions') }}</th>
                            <th>{{ trans('labels.backend.access.roles.table.number_of_users') }}</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.card-body -->
    </div><!--box-->

    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">{{ trans('history.backend.recent_history') }}</h3>
            <div class="card-tools float-right">
                <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            </div><!-- /.box tools -->
        </div><!-- /.card-header -->
        <div class="card-body">
            {!! history()->renderType('Role') !!}
        </div><!-- /.card-body -->
    </div><!--card-->
@stop
@push('after-scripts')
<!-- DataTables -->
    {{ script('vendor/datatables/jquery.dataTables.min.js') }}
    {{ script('vendor/datatables-bs4/js/dataTables.bootstrap4.min.js') }}

    <script>
        $(function() {
            $('#roles-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.access.role.get") }}',
                    type: 'post',
                    data: {_token: Laravel.csrfToken}
                },
                columns: [
                    {data: 'name', name: '{{ config('access.roles_table') }}.name', render: $.fn.dataTable.render.text()},
                    {data: 'permissions', name: '{{ config('access.permissions_table') }}.display_name', sortable: false},
                    {data: 'users', name: 'users', searchable: false, sortable: false},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
@endpush