@extends ('admin.layouts.app')

@section('title', 'Profile')

@section('page-header')
    <h1>
        Profile
        <small>My Profile</small>
    </h1>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-3">

            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle" src="{{ $user->picture }}"
                            alt="User profile picture">
                    </div>
                    <h3 class="profile-username text-center">{{$user->name}}</h3>
                   
                </div>

            </div>

        </div>

        <div class="col-md-9">
            <div class="card">
                <div class="card-header p-2">
                    <ul class="nav nav-pills">
                        <li class="nav-item"><a class="nav-link active" href="#info"
                                data-toggle="tab">My Info</a></li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content">
                        <div class="tab-pane active" id="info">
                            <form action="{{route('admin.user.profile')}}" method="post" class="form-horizontal">
                                @csrf
                                <div class="form-group row">
                                    <label for="name" class="col-sm-2 col-form-label">Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="name" class="form-control" id="name" placeholder="Full Name" value="{{$user->name}}" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="email" class="col-sm-2 col-form-label">Email</label>
                                    <div class="col-sm-10">
                                        <input type="email" name="email" class="form-control" id="email" placeholder="Email" value="{{$user->email}}" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="mobile_number" class="col-sm-2 col-form-label">Mobile Number</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="mobile_number" class="form-control" id="mobile_number" placeholder="Mobile Number" value="{{$user->profile->mobile}}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="address" class="col-sm-2 col-form-label">Address</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="address" class="form-control" id="address" placeholder="Address" value="{{$user->profile->address}}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="gender" class="col-sm-2 col-form-label">Gender</label>
                                    <div class="col-sm-10">
                                        <select class="form-control" name="gender" required>
                                            <option value="">--Select--</option>
                                            <option value="male" {{$user->profile->gender == 'male' ? 'selected' : ''}}>Male</option>
                                            <option value="female" {{$user->profile->gender == 'female' ? 'selected' : ''}}>Female</option>
                                            <option value="other" {{$user->profile->gender == 'other' ? 'selected' : ''}}>Other</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="about_me" class="col-sm-2 col-form-label">About Me</label>
                                    <div class="col-sm-10">
                                        <textarea class="form-control" name="about" id="about_me" placeholder="About me...">{{$user->profile->about}}</textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="profile-picture" class="col-sm-2 col-form-label">Profile Picture</label>                  
                                    <div class="col-md-4">
                                        <div class="input-group" data-toggle="seshra-uploader" data-type="image" data-group="profile">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text bg-soft-secondary font-weight-medium">Browse</div>
                                            </div>
                                            <div class="form-control file-amount">Choose File</div>
                                            <input type="hidden" name="profile_picture" class="selected-files" value="{{$user->profile->profile_picture}}">
                                        </div>
                                        <div class="file-preview box sm"></div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="offset-sm-2 col-sm-10">
                                        <button type="submit" class="btn btn-danger">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>

                </div>
            </div>

        </div>

    </div>
@stop
