(function( $ ){

  $.fn.filemanager = function(type, options) {
    type = type || 'file';

    this.on('click', function(e) {
      var route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
      var target_input = $('#' + $(this).data('input'));
      //added by raj
      var target_input_id = $('#'+$(this).data('mediaid'));
      var target_preview = $('#' + $(this).data('preview'));

      window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
      window.SetUrl = function (items) {
        var file_path = items.map(function (item) {
          return item.url;
        }).join(',');

          var file_id = items.map(function (item) {
              return item.id;
          }).join(',');

        // set the value of the desired input to image url
        target_input.val('').val(file_path).trigger('change');
        target_input_id.val('').val(file_id).trigger('change');

        // clear previous preview
        target_preview.html('');
        $('.remove_featured_image').show();

        // set or change the preview image src
        items.forEach(function (item) {
          target_preview.append(
            $('<img>').css('margin-top', '15px').css('max-height','100px').attr('src', item.thumb_url)
          );
        });

        // trigger change event
        target_preview.trigger('change');
      };
      return false;
    });
  }

})(jQuery);
