<?php
namespace Database\Seeders;

use Carbon\Carbon as Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class MenuTableSeeder
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class MenuTableSeeder extends Seeder {

	/**
	 * Run the database seed.
	 *
	 * @return void
	 */
	public function run() {

		if (DB::connection()->getDriverName() == 'mysql') {
			DB::statement('SET FOREIGN_KEY_CHECKS=0;');
		}

		if (DB::connection()->getDriverName() == 'mysql') {
			DB::table('menus')->truncate();
		} elseif (DB::connection()->getDriverName() == 'sqlite') {
			DB::statement('DELETE FROM menus');
		} else {
			//For PostgreSQL or anything else
			DB::statement('TRUNCATE TABLE menus CASCADE');
		}

		 $menus = [
            [
                'id' => 1,
                'title' => 'Main Menu',
                'slug' => 'main-menu',
                'selected' => '1',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ],
            [
             	'id' => 2,
                'title' => 'Footer Menu',
                'slug' => 'footer-menu',
                'selected' => '0',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]
        ];

		DB::table('menus')->insert($menus);

		if (DB::connection()->getDriverName() == 'mysql') {
			DB::statement('SET FOREIGN_KEY_CHECKS=1;');
		}
	}
}