<?php
namespace Database\Seeders;

use Carbon\Carbon as Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class CategoryTableSeeder
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class CategoryTableSeeder extends Seeder {

	/**
	 * Run the database seed.
	 *
	 * @return void
	 */
	public function run() {

		if (DB::connection()->getDriverName() == 'mysql') {
			DB::statement('SET FOREIGN_KEY_CHECKS=0;');
		}

		if (DB::connection()->getDriverName() == 'mysql') {
			DB::table('categories')->truncate();
		} elseif (DB::connection()->getDriverName() == 'sqlite') {
			DB::statement('DELETE FROM categories');
		} else {
			//For PostgreSQL or anything else
			DB::statement('TRUNCATE TABLE categories CASCADE');
		}

		 $category = [
            [
                'id' => 1,
                '_lft' => 1,
                '_rgt' => 2,
                'parent_id' => NULL,
                'slug' => 'miscellaneous',
                'status' => '1',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]
        ];

		DB::table('categories')->insert($category);
		foreach(config('translatable.locales') as $locale) {
			DB::table('category_translations')->insert([
				'category_id' => 1,
				'title' => 'Miscellaneous',
				'locale' => $locale
			]);
		}

		if (DB::connection()->getDriverName() == 'mysql') {
			DB::statement('SET FOREIGN_KEY_CHECKS=1;');
		}
	}
}