<?php
namespace Database\Seeders;

use Database\Seeders\Access\PermissionRoleSeeder;
use Database\Seeders\Access\PermissionTableSeeder;
use Database\Seeders\Access\ProfileTableSeeder;
use Database\Seeders\Access\RoleTableSeeder;
use Database\Seeders\Access\UserRoleSeeder;
use Database\Seeders\Access\UserTableSeeder;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class AccessTableSeeder
 */
class AccessTableSeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
    {
        if (DB::connection()->getDriverName() == 'mysql') {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        }

        // $this->call(UserTableSeeder::class);  //commented for installer
        // $this->call(ProfileTableSeeder::class); //commented for installer
        $this->call(RoleTableSeeder::class);
        // $this->call(UserRoleSeeder::class); //commented for installer
        $this->call(PermissionTableSeeder::class);
        $this->call(PermissionRoleSeeder::class);

        if (DB::connection()->getDriverName() == 'mysql') {
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        }
    }
}
