<?php
namespace Database\Seeders\Access;

use Carbon\Carbon as Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

/**
 * Class ProfileTableSeeder
 */
class ProfileTableSeeder extends Seeder
{
	/**
	 * Run the database seed.
	 *
	 * @return void
	 */
	public function run()
    {
        if (DB::connection()->getDriverName() == 'mysql') {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        }

        if (DB::connection()->getDriverName() == 'mysql') {
            DB::table(config('access.profiles_table'))->truncate();
        } elseif (DB::connection()->getDriverName() == 'sqlite') {
            DB::statement('DELETE FROM ' . config('access.profiles_table'));
        } else {
            //For PostgreSQL or anything else
            DB::statement('TRUNCATE TABLE ' . config('access.profiles_table') . ' CASCADE');
        }

        //Add the master administrator, user id of 1 profile
        $profiles = [
            [
                'user_id'             => 1,
                'firstname'          => 'Administrator',
                'lastname' => 'User',
                'gender'         => 'male',
                'dob'         => '1993-02-14',
                'created_at'        => Carbon::now(),
                'updated_at'        => Carbon::now(),
            ],
            // [
            //     'user_id'             => 2,
            //     'firstname'          => 'Editor',
            //     'lastname' => 'User',
            //     'gender'         => 'male',
            //     'dob'         => '1993-02-14',
            //     'created_at'        => Carbon::now(),
            //     'updated_at'        => Carbon::now(),
            // ],
            // [
            //     'user_id'             => 3,
            //     'firstname'          => 'Guest',
            //     'lastname' => 'User',
            //     'gender'         => 'male',
            //     'dob'         => '1993-02-14',
            //     'created_at'        => Carbon::now(),
            //     'updated_at'        => Carbon::now(),
            // ],
        ];

        DB::table(config('access.profiles_table'))->insert($profiles);

        if (DB::connection()->getDriverName() == 'mysql') {
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        }
    }
}