<?php

use App\Models\Access\Role\Role;
use App\Models\Access\Permission\Permission;

return [

	/*
	 * Users table used to store users
	 */
	'users_table' => 'users',

	/*
	 * Users table used to store user profile
	 */
	'profiles_table' => 'profiles',

	/*
	 * Role model used by Access to create correct relations. Update the role if it is in a different namespace.
	*/
	'role' => Role::class,

	/*
	 * Roles table used by Access to save roles to the database.
	 */
	'roles_table' => 'roles',

	/*
	 * Permission model used by Access to create correct relations.
	 * Update the permission if it is in a different namespace.
	 */
	'permission' => Permission::class,

	/*
	 * Permissions table used by Access to save permissions to the database.
	 */
	'permissions_table' => 'permissions',

	/*
	 * permission_role table used by Access to save relationship between permissions and roles to the database.
	 */
	'permission_role_table' => 'permission_role',

	/*
	 * role_user table used by Access to save assigned roles to the database.
	 */
	'role_user_table' => 'role_user',

	/*
	 * Configurations for the user
	 */
	'users' => [
		/*
		 * The role the user is assigned to when they sign up from the frontend, not namespaced
		 */
		'default_role' => 'User',
		//'default_role' => 2,

		/*
		 * Whether or not the user has to confirm their email when signing up
		 */
		'confirm_email' => true,

		/*
		 * Whether or not the users email can be changed on the edit profile screen
		 */
		'change_email' => true,
	],

	/*
	 * Configuration for roles
	 */
	'roles' => [
		/*
		 * Whether a role must contain a permission or can be used standalone as a label
		 */
		'role_must_contain_permission' => true
	],

	/*
	 * Socialite session variable name
	 * Contains the name of the currently logged in provider in the users session
	 * Makes it so social logins can not change passwords, etc.
	 */
	'socialite_session_name' => 'socialite_provider',

	/*
	 * Application captcha specific settings
	 */
	'captcha' => [
		/*
		 * Whether the registration captcha is on or off
		 */
		'registration' => env('REGISTRATION_CAPTCHA_STATUS', false),
	],
	// 'admin_bar' => function () {
    //     if(!auth()->guest()) {
	// 		return setting('admin-bar', true);
	// 	}
	// 	return false;
	// },
	'admin_bar' => false,
	'secure' => env('SECURE', false),
	'INSTALLED' => env('INSTALLED', false)
];