<?php
/**
 * File GalleryShortcode.php
 *
 * Created by PhpStorm.
 *
 * @author Raj K. Shrestha on 2020-05-13 18:59
 */

namespace App\Shortcodes;

use App\Models\Gallery\Gallery;
use Rawbinn\Media\Models\Media;

class GalleryShortcode
{
    public function register($shortcode, $content, $compiler, $name, $viewData)
    {
        $html = '';
        if (is_numeric($shortcode->key)) {
            $gallery = Gallery::where('id', $shortcode->key)->first();
        } else {
            $gallery = Gallery::where('slug', $shortcode->key)->first();
        }
        if ($gallery) {
            if ($shortcode->limit) {
                $items = $gallery->items()->with('media')->paginate($shortcode->limit);
            } else {
                $items = $gallery->items()->with('media')->get();
            }
            $cols = is_numeric($shortcode->cols) ? $shortcode->cols : 4;
            $bcols = 12 / $cols;
            $total_items = $items->count();
            $counter = 0;
            $html .= '<div class="shortcodes-gallery">';
            foreach ($items as $key => $item) {
                if ($key == 0) {
                    $html .= '<div class="row">';
                }
                $image_url = $item->media ? public_asset('storage/'.str_replace('\\', '/', $item->media->path)) : null;
                if ($image_url != null) {
                    $html .= '
                    <div class="col-md-'.$bcols.'">
                        <a class="" href="'.$image_url.'" data-lightbox="'.$gallery->slug.'" data-title="'.$item->title.'">
                            <img class="img-fluid" src="'.$image_url.'" alt="'.$item->title.'"/>
                        </a>
                    </div>';
                }
                ++$counter;
                if ($counter % $cols == 0) {
                    $html .= '</div><div class="row">';
                }
                if ($counter == $total_items) {
                    $html .= '</div>';
                }
            }
            $html .= '</div>';
        }

        return $html;
    }

}
