<?php
namespace App\Repositories\Frontend;

use DB;
use App\Mail\ContactMail;
use App\Modules\Contact\Models\Contact;
use App\Modules\Contact\Models\ContactResponse;
use Illuminate\Support\Facades\Mail;

/**
 * Class PageRepository
 * @package App\Repositories\Frontend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class PageRepository
{

    public function sendMail(array $data)
    {
        $contact = Contact::where('slug', $data['formName'])->first();
        if ($contact != null) {
            $contact->email = $contact->receiver_email;
            $contact->name = setting('site-title', app_name()) . ' Contact';
            unset($data['formName']);
            try {
                if($contact->send_in_email) {
                    Mail::to($contact)->send(new ContactMail($data));
                }
                ContactResponse::create([
                    'contact_form_id' => $contact->id,
                    'response' => json_encode($data)
                ]);
            } catch (\Exception $e) {
                session(['flash_danger' => $e->getMessage()]);
                //session(['flash_danger' => 'There is some error occured during sending mail. Please contact administrator.']);
                return false;
            }
            session(['flash_success' => $contact->success_message]);
            return true;
        }

    }

}
