<?php

namespace App\Repositories\Frontend;

use Menu;
use App\Models\Menu\MenuItem;
use App\Exceptions\GeneralException;

/**
 * Class MenuRepository
 * @package App\Repositories\Frontend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class MenuRepository
{  

     /**
     * Returns top level menu list
     * @param null 
     * @return collection
     */
    public function getTopLevelMenu()
    {
        return MenuItem::where('parent_id','0')->orderBy('sort','asc')->get();
    }

    /**
     * 
     */
    public function loadMenu()
    {
      $menuitems = $this->getTopLevelMenu();
        Menu::make('top-menu', function($menu) use ($menuitems){
         
           foreach ($menuitems as $menuitem) {//2
            $menu->add($menuitem->title, ['route' => ['page',$menuitem->url]])->nickname($menuitem->slug);
            
              if(!$menuitem->children->isEmpty()){
                
                foreach($menuitem->children as $childmenu){//3

                    $menu->item($menuitem->slug)->add($childmenu->title, ['route' => ['page',$menuitem->url]])->nickname($childmenu->slug);

                    if(!$childmenu->children->isEmpty()){
                        foreach($childmenu->children as $subchildmenu){

                            $menu->item($childmenu->slug)->add($subchildmenu->title, ['route' => ['page',$menuitem->url]])->nickname($subchildmenu->slug);

                        }
                    }
                      
                }
            }
            
          }           

        });
        
    }

}
