<?php

namespace App\Repositories\Frontend;

use App\Models\Post\Post;
use App\Exceptions\GeneralException;

/**
 * Class BlogRepository
 * @package App\Repositories\Frontend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class BlogRepository
{
 
 public function getBlogsWithPaginate($paginate=5, $category = null)
 {
 	if( $category == null ) {
 		return Post::paginate($paginate);
 	}
 	elseif( is_array($category) ) {
 		return Post::whereIn('category_id', $category)->paginate($paginate);
 	}
 	else {
 		return Post::where('category_id', $category)->paginate($paginate);
 	}
 }

 public function getBlogsByType($type, $limit, $paginate = false)
 {
 	if($limti == 1) {
 		return Post::where('type', $type)->first();
 	}

 	return Post::where('type', $type)->get();
 }

 public function getBlogs()
 {
 	return Post::get();
 } 

 public function getBlog($slug)
 {
 	$blog = Post::where('slug', $slug)->firstorfail();
 	return $blog;
 }

 public function findById($id)
 {
 	return Post::find($id);
 }
 
 public function search($data, $pagination = 10)
 {
	 $posts = Post::where('type','post')->active()->whereTranslationLike('title', '%'.$data.'%')->orWhereTranslationLike('content', '%'.$data.'%')->paginate($pagination);
	 return $posts;
 }
}