<?php
/**
 * Class WidgetRepository.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:25 PM
 */

namespace App\Repositories\Backend;

use App\Exceptions\GeneralException;
use App\Models\Widget\Widget;
use App\Repositories\Repository;
use Illuminate\Database\Eloquent\Model;
use Theme;

class WidgetRepository extends Repository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = Widget::class;

    /**
     * @param $data
     *
     * @throws GeneralException
     */
    public function create($data)
    {
        $widget = self::MODEL;
        $widget = new $widget();
        $widget->title = $data['title'];
        $widget->display_area = $data['display'];

        if ($data['content_from'] == 'block') {
            $widget->type = 'block';
            $content = $data['block'];
        } elseif ($data['content_from'] == 'widget_plugin') {
            $widget->type = 'widget_plugin';
            $content = $data['widget_plugin'];
        } else {
            $content = null;
        }
        $widget->content = $content;
        $widget->show_title = (isset($data['show'])) ? '1' : '0';

        if (parent::save($widget)) {
            return true;
        }

        throw new GeneralException('There is some error occured during adding new widget');
    }

    public function getWidgetsArea($area = 'widgets')
    {
        $widgets = Theme::getFunctionProperty(setting('theme-active', config('themes.active')), $area);

        return $widgets ?? [];
    }

    /**
     * @return bool
     *
     * @throws GeneralException
     */
    public function delete(Model $widget)
    {
        if (parent::delete($widget)) {
            return true;
        }

        throw new GeneralException('There is some error occured during deleting widget.');
    }

    public function updateBlock($input)
    {
        $widget = $this->query()->where('slug', $input['slug'])->first();
        if ($widget != null) {
            $widget->title = $input['title'];
            $widget->show_title = ($input['show'] == 'true') ? '1' : '0';
            $widget->content = $input['content'];
            if ($widget->save()) {
                return true;
            }
        }

        return false;
    }

    public function deleteBlock($input)
    {
        if ($this->query()->where('id', $input['id'])->delete()) {
            return true;
        }

        return false;
    }

    public function getAllWidgetPlugins()
    {
    }
}
