<?php

namespace App\Repositories\Backend;

use DB;
use Exception;
use App\Repositories\Repository;
use App\Models\Tag\Tag;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TagRepository
 * @package App\Repositories\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class TagRepository extends Repository
{
    /**
     * Associated Repository Model
     */
    const MODEL = Tag::class;

    /**
     * @param array $data
     * @return bool
     * @throws GeneralException
     */
    public function  create(array $data)
    {
        $tag = self::MODEL;
        $tag = new $tag;
        if($tag->where('title', $data['title'])->count()>0){
            throw new GeneralException('This tag already exist. Please add unique tag.');
        }
        $tag->title = strip_tags($data['title']);
        $tag->slug = ($data['slug']!='') ? $this->slug($this->make_slug($data['slug'],'-')) : $this->slug($this->make_slug($data['title'],'-'));
        $tag->description = filter_var($data['description'], FILTER_SANITIZE_STRING);
        
        if(parent::save($tag))
            return true;

        throw new GeneralException(trans('exceptions.backend.tag.update_error'));
    }

    /**
     * @param Model $tag
     * @param array $input
     */
    public function update(Model $tag, array $input)
    {
        $data = array();
        $data['title'] = strip_tags($input['title']);
        $data['description'] = filter_var($input['description'], FILTER_SANITIZE_STRING);
        if($input['slug'] != $tag->slug) {
            $data['slug'] = ($input['slug']!='') ? $this->slug($this->make_slug($input['slug'],'-')) : $this->slug($this->make_slug($input['title'],'-'));
        }
        if (parent::update($tag, $data)) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.tag.update_error'));
    }
    /**
     * 
     */
    public function slug($slug, $tag_id = null)
    {
        if($tag_id!=null){
            $count = $this->query()->where('id', '<>', $tag_id)->where('slug', $slug)->count();
            if ($count > 0) {
                return $this->slug($slug . '-' . rand(0, 20), $tag_id);
            }
        }
        else{
            $count = $this->query()->where('slug', $slug)->count();
            if ($count > 0) {
                return $this->slug($slug . '-' . rand(0, 20), $tag_id);
            }
        }
        return $slug;
    }

    public function make_slug($string, $seperator = '-') {
        return preg_replace('/\s+/u', $seperator, trim($string));
    }

    public function search($q)
    {
        return $this->query()->select('title')->where('title', 'like', $q.'%')->pluck('title')->toArray();
    }

}
