<?php

namespace App\Repositories\Backend;

use App\Models\Slider\Slider;
use App\Repositories\Repository;
use Illuminate\Support\Facades\DB;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;

/**
 * Class SliderRepository
 * @package App\Repositories\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class SliderRepository extends Repository
{
    /**
     * Associated Repository Model
     */
    const MODEL = Slider::class;

    /**
     * @param bool $trashed
     * @return mixed
     */
    public function getForDataTable()
    {
        /**
         * Note: You must return deleted_at or the User getActionButtonsAttribute won't
         * be able to differentiate what buttons to show for each row.
         */
        $dataTableQuery = $this->query()
            ->select([
                'id',
                'name',
                'created_at',
                'updated_at'
            ])
            ->orderBY('id', 'desc');
        return $dataTableQuery;
    }

    /**
     * @param $data
     * @throws GeneralException
     */
    public function create($data)
    {
        $slider = self::MODEL;
        $slider = new $slider;
        $slider->name = $data['name'];

        if (parent::save($slider)) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.slider.update_error'));
    }

    /**
     * @param Model $slider
     * @param array $input
     */
    public function update(Model $slider, array $input)
    {
        $data = array();
        $data['name'] = $input['name'];

        // $slug = Slider::find($input['slug']);
        // if (count($slug) == 0) {
        //     $data['slug'] = $input['slug'];
        // }

        if (parent::update($slider, $data)) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.page.update_error'));
    }

    /**
     * @param Model $page
     * @return bool
     * @throws GeneralException
     */
    public function delete(Model $slider)
    {
        if (parent::delete($slider)) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.slider.delete_error'));
    }

    /**
     * @param Model $page
     * @throws GeneralException
     */
    public function forceDelete(Model $page)
    {
        DB::transaction(function () use ($page) {
            if (parent::forceDelete($page)) {
                return true;
            }

            throw new GeneralException(trans('exceptions.backend.page.delete_error'));
        });
    }

    /**
     * @param Model $page
     * @return bool
     * @throws GeneralException
     */
    public function restore(Model $page)
    {
        if (parent::restore(($page))) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.page.restore_error'));
    }

}
