<?php

namespace App\Repositories\Backend;

use DB;
use App\Repositories\Repository;
use Rawbinn\Media\Models\Media;

/**
 * Class MediaRepository
 * @package App\Repositories\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class MediaRepository extends Repository
{
    /**
     * Associated Repository Model
     */
    const MODEL = Media::class;

    protected $model;

    public function __construct()
    {
        $this->model = $this->query();
    }

    public function dateForOption()
    {
       return $this->query()->select(DB::raw('YEAR(created_at) year, MONTH(created_at) month'))
        ->groupby('year','month')->orderBy('month','DESC')
        ->get();
    }


    public function type($type)
    {
        $this->model = $this->query()->where('type', $type);
        return $this;
    }

    public function extension($extension)
    {
        $this->model = $this->model->where('extension', $extension);
        return $this;
    }

    public function date($date)
    {
        if(is_array($date)) {
            $count = count($date);
            if($count == 1)
                $this->model = $this->model->whereYear('created_at', $date[0]);
            else
                $this->model = $this->model->whereYear('created_at', $date[0])->whereMonth('created_at', $date[1]);
        }
        else{
            $this->model = $this->model->where('created_at', '=', $date);
        }
        return $this;
    }

    public function paginate($paginate = 5)
    {
        return $this->model->paginate($paginate);
    }

}
