<?php

namespace App\Modules\Contributor\Providers;

use Caffeinated\Modules\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadViewsFrom(module_path('contributor', 'Resources/Views', 'app'), 'contributor');

        Event::listen('larapress.blog.sidebar.after', function ($eventManager) {
            $params = $eventManager->getParams();
            $contributor = isset($params['blog']) ? $params['blog']->metaByKey('contributor') : '';
            $eventManager->setParams(['contributor' => $contributor]);
            $eventManager->addTemplate('contributor::input');
        });

        Event::listen('larapress.blog.create.end', function ($eventManager) {
            $params = $eventManager->getParams();
            foreach (locales() as $locale) {
                $params['blog']->meta()->create([
                    'key' => 'contributor',
                    'value' => $params['inputs']['contributor'] ?? '',
                    'locale' => $locale,
                    'sort' => 1
                ]);
            }
        });

        Event::listen('larapress.blog.update.end', function ($eventManager) {
            $params = $eventManager->getParams();
            if (isset($params['blog']) && isset($params['inputs'])) {
                $meta = $params['blog']->metas()->where('locale', $params['inputs']['lang'])->where('key', 'contributor')->first();
                if ($meta) {
                    $meta->value = $params['inputs']['contributor'] ?? '';
                    $meta->save();
                } else {
                    $params['blog']->meta()->create([
                        'key' => 'contributor',
                        'value' => $params['inputs']['contributor'] ?? '',
                        'locale' => $params['inputs']['lang'],
                        'sort' => 1
                    ]);
                }
            }
        });
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        // 
    }
}
