@extends ('admin.layouts.app')

@section ('title', 'Contact Responses')

@section('page-header')
    <h1>
        Contact Responses
    </h1>
@endsection

@section('content')
    
    <div class="card">
        <div class="card-header with-border">
            <h3 class="card-title">Contact Responses</h3>
        </div><!-- /.box-header -->

        <div class="card-body">
            <div class="table-responsive">
                <table id="contact-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Response</th>
                        <th>Seen</th>
                        <th>{{ trans('labels.backend.table.created') }}</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach($responses as $response)
                            <tr>
                                <td>{{$response->id}}</td>
                                <td>
                                    @php $contents = json_decode($response->response, true)@endphp
                                    @foreach($contents as $key => $content)
                                        <b>{{ucwords(str_replace('_', ' ', $key))}}</b> : {{$content}} <br>
                                    @endforeach
                                </td>
                                <td>
                                    @if($response->viewed == 1)
                                        <span class="badge badge-inline badge-md badge-success">Seen</span>
                                    @else
                                        <span class="badge badge-inline badge-md badge-danger">Not Seen</span>
                                    @endif
                                </td>
                                <td>{{$response->created_at}}</td>
                                <td></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {!! $responses->links() !!}
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->
@stop

@push('after-scripts')

@endpush
