@extends ('admin.layouts.app')

@section ('title', 'Contact Form | Edit Contact Form')

@section('page-header')
    <h1>
        Contact Form
        <small>Edit Contact Form</small>
    </h1>
@endsection

@section('content')
    {{ Form::model($contact, ['route' => ['admin.contact.update', $contact->id], 'role' => 'form', 'method' => 'put']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Edit Contact Form</h3>
            </div><!-- /.box-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', 'Title') }}
                    {{ Form::text('title', $contact->name, ['class' => 'form-control', 'placeholder' => 'Contact Title', 'required']) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('key', 'Key') }}
                    {{ Form::text('key', $contact->slug, ['class' => 'form-control', 'placeholder' => 'Key', 'required']) }}
                </div><!--form group-->

                <div class="form-group">
                    <label for="content">Contact Form</label>
                    {{ Form::textarea('form', null, ['class' => 'form-control']) }}
                </div>
                <div class="form-group">
                    {{ Form::label('email', 'Receiver Email') }}
                    {{ Form::email('email',$contact->receiver_email, ['class' => 'form-control', 'placeholder' => 'Receiver Email', 'required']) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('message', 'Success Message') }}
                    {{ Form::text('message', $contact->success_message, ['class' => 'form-control', 'placeholder' => 'Success Message']) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('send_email', 'Send Response In Email Too') }}
                    <input type="hidden" name="send_in_email" value="0">
                    <input type="checkbox" name="send_in_email" value="1" {{$contact->send_in_email ? 'checked' : ''}}>
                </div><!--form group-->
            </div><!-- /.box-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.contact.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--pull-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--pull-right-->

                <div class="clearfix"></div>
            </div><!-- /.box-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')

@endpush
