@extends ('admin.layouts.app')

@section ('title', 'Contact Form | Create Contact')

@section('page-header')
    <h1>
        Contact Form
        <small>Add Contact Form</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.contact.store', 'role' => 'form', 'method' => 'post']) }}

        <div class="card">
            <div class="card-header with-border">
                <h3 class="card-title">Add Contact</h3>
            </div><!-- /.box-header -->

            <div class="card-body">
                <div class="form-group">
                    {{ Form::label('title', 'Title') }}
                    {{ Form::text('title', null, ['class' => 'form-control', 'placeholder' => 'Contact Title', 'required']) }}
                </div><!--form group-->

                <div class="form-group">
                    <label for="content">Contact Form</label>
                    {{ Form::textarea('form', null, ['class' => 'form-control']) }}
                </div>
                <div class="form-group">
                    {{ Form::label('email', 'Receiver Email') }}
                    {{ Form::email('email',null, ['class' => 'form-control', 'placeholder' => 'Receiver Email', 'required']) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('message', 'Success Message') }}
                    {{ Form::text('message', null, ['class' => 'form-control', 'placeholder' => 'Success Message']) }}
                </div><!--form group-->
                <div class="form-group">
                    {{ Form::label('send_email', 'Send Response In Email Too') }}
                    <input type="hidden" name="send_in_email" value="0">
                    <input type="checkbox" name="send_in_email" value="1">
                </div><!--form group-->
            </div><!-- /.box-body -->
        </div><!--box-->

        <div class="card">
            <div class="card-body">
                <div class="float-left">
                    {{ link_to_route('admin.contact.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-xs']) }}
                </div><!--pull-left-->

                <div class="float-right">
                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-xs']) }}
                </div><!--pull-right-->

                <div class="clearfix"></div>
            </div><!-- /.box-body -->
        </div><!--box-->

    {{ Form::close() }}
@stop

@push('after-scripts')

@endpush
