<?php
namespace App\Modules\Contact\Models;

/**
 * Class Event
 * @package App\Modules\Contact\Models
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use Illuminate\Database\Eloquent\Model;
use App\Services\Sluggable;
use App\Modules\Contact\Models\ContactAttributes;
use App\Services\ActiveScope;
use App\Services\StatusLabelTrait;

class Contact extends Model
{

    use ContactAttributes, Sluggable, StatusLabelTrait, ActiveScope;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'contact_forms';
    }


    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable() : array
    {
        return [
            'source' => 'name',
        ];
    }

    public function responses()
    {
        return $this->hasMany(ContactResponse::class, 'contact_form_id');
    }

}
