<?php

namespace App\Modules\Contact\Http\Controllers;

use App\Models\Post\Post;
use App\Models\Post\PostMeta;
use App\Modules\Contact\Models\Contact;
use App\Modules\Contact\Models\ContactResponse;
use DataTables;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Validator;

class ContactController extends Controller
{
    public function index()
    {
        $contact_forms = Contact::active()->paginate(10);
        return view('contact::index', compact('contact_forms'));
    }

    public function create()
    {
        return view('contact::create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'email' => 'required|email',
            'send_in_email' => 'required|in:0,1'
        ]);

        $contact = new Contact();
        $contact->name = $request->title;
        $contact->form = $request->form;
        $contact->status = 1;
        $contact->receiver_email = $request->email;
        $contact->success_message = $request->message;
        $contact->send_in_email = $request->send_in_email;
        if ($contact->save()) {
            return redirect()->route('admin.contact.index')->withFlashSuccess('New contact form added successfully.');
        }
    }

    public function edit($id)
    {
        $contact = Contact::find($id);

        return view('contact::edit')->withContact($contact);
    }

    public function update($id, Request $request)
    {
        $request->validate([
            'title' => 'required',
            'key' => 'required',
            'email' => 'required|email',
            'send_in_email' => 'required|in:0,1'
        ]);

        $contact = Contact::findOrFail($id);
        $contact->name = $request->title;
        $contact->slug = $request->key;
        $contact->form = $request->form;
        $contact->receiver_email = $request->email;
        $contact->success_message = $request->message;
        $contact->send_in_email = $request->send_in_email;
        if ($contact->save()) {
            return redirect()->route('admin.contact.index')->withFlashSuccess('Contact form updated successfully.');
        }
    }

    public function delete($id)
    {
        $contact = Contact::findOrFail($id);
        if ($contact->delete()) {
            return redirect()->back()->withFlashSuccess('Contact form deleted successfully.');
        }

        return redirect()->back()->withFlashDanger('There is some error occured during deleting contact form.');
    }

    public function show($id)
    {
        $contact = Contact::findOrFail($id);
        $responses = ContactResponse::where('contact_form_id', $contact->id)->orderBy('id', 'DESC')->paginate(10);
        return view('contact::show', compact('responses'));
    }
}
