<?php 
namespace App\Modules\Citytracking\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use SoapClient;

class CityTrackingController extends Controller
{
    public function track(Request $request)
    {
        
        if(!$request->has('g-recaptcha-response') || $request->input('g-recaptcha-response') == '') {
            return response()->json([
                'status'  => false,
                'message' => 'Please check the captcha form.'
                ]);
        }

        try{
            $captcha = $request->input('g-recaptcha-response');
            $secretKey = get_option('recaptcha-secret-key');
            $ch = curl_init();

            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://www.google.com/recaptcha/api/siteverify',
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => [
                    'secret' => $secretKey,
                    'response' => $captcha,
                    'remoteip' => $request->ip()
                ],
                CURLOPT_RETURNTRANSFER => true
            ]);
            
            $output = curl_exec($ch);
            curl_close($ch);
            $output = json_decode($output, true);
        
            if($output["success"]) {
                $text2 = $request->control_number;        
                $params = array(			
                            'REFNO' 			=> $text2,
                            'TXN_DATE' 			=> '',
                            'SENDER_NAME'		=> '',
                            'SENDER_PASSPORT'	=> ''			
                        );		
                    
                $wsdl   = "https://www.ct-xpress.net/WebApi/websiteAPI.asmx?WSDL";
            
                $soap  		 	= new SoapClient($wsdl);
        
                $result 	 	= $soap->getTransactionStatus($params);
                
                $code 			= $result->getTransactionStatusResult->CODE;
                $rfno 			= $result->getTransactionStatusResult->REFNO;
                $status 		= $result->getTransactionStatusResult->STATUS;
                $statusdate 	= $result->getTransactionStatusResult->STATUS_DATE;
                return response()->json([
                    'status' => true,
                    'message' => 'Data has been successfully fetched.',
                    'data' => [
                        'refno' => $rfno,
                        'status' => $status,
                        'html' => '<h2>Transaction Status</h2><h3>Transaction No:  '.$rfno.'</h3><h3>Status: '.$status.'</h3></div>'
                    ]
                ]);
            }
        } catch(\Exception $e) {
            return response()->json(['status' => false, 'message' => $e->getMessage()]);
        }
        
        
    }
    
}