<?php

namespace App\Models\Widget;

use DB;

/**
 * Class Widgetttribute
 * @package App\Models\Widget
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait WidgetAttribute
{

      /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="#" class="btn btn-xs btn-primary"><i class="fa fa-pencil-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }


    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '<a href="' . route('admin.widget.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }


    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return
            $this->getEditButtonAttribute() .
            $this->getDeleteButtonAttribute();
    }
}