<?php

namespace App\Models\Slider;

use DB;

/**
 * Class SliderAttribute
 * @package App\Models\Slider
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait SliderAttribute
{

    /**
     * @return string
     */
    public function getShowButtonAttribute()
    {
        return '<a href="' . route('admin.slider.show', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-search" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.view') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getAddButtonAttribute()
    {
        return '
        <a href="' . route('admin.slider.item.create', $this) . '" class="btn btn-xs btn-info">
        <i class="fa fa-plus" data-toggle="tooltip" data-placement="top" title="Add Slider Items"></i>
        </a> 
        <a href="'.route('admin.slider.item.index', $this).'" class="btn btn-xs btn-primary">All Slide Items</a>
        ';
    }

    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="' . route('admin.slider.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '<a href="' . route('admin.slider.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return
        //$this->getShowButtonAttribute() .
        $this->getAddButtonAttribute() .
        $this->getEditButtonAttribute() .
        $this->getDeleteButtonAttribute();
    }
}
