<?php
namespace App\Models\Slider;

/**
 * Class Slider
 * @package app\Models\Slider
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use App\Services\Sluggable;
use App\Models\Slider\SliderAttribute;
use Illuminate\Database\Eloquent\Model;


class Slider extends Model {

    use SliderAttribute, Sluggable;
    
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'sliders';
    }

    public function items()
    {
        return $this->hasMany(SliderItem::class, 'slider_id', 'id');
    }

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable() {
        return [
            'source' => 'name',
        ];
    }

}
