<?php

namespace App\Models\Post;

use Illuminate\Support\Facades\Request;

trait PostMetaRelation
{
    public function meta()
    {
        return $this->hasOne(PostMeta::class, 'post_id');
    }

    public function metas()
    {
        return $this->hasMany(PostMeta::class, 'post_id');
    }

    public function metaList()
    {
        return $this->metas()->pluck('value', 'key')->toArray();
    }

    public function metaByKey($key, $all = false, $lang = 'en')
    {
        if ($all === false) {
            $meta = $this->meta()->where('locale', $lang)->where('key', $key)->first();
            if ($meta) {
                return $meta->value;
            }
            return null;
        }
        $metas = $this->meta()->where('locale', $lang)->where('key', $key)->pluck('value')->toArray();
        return $metas;
    }


    public function updateByMetaKey($key, $value, $lang = 'en')
    {
        return $this->meta()->where('locale', $lang)->where('key', $key)->update(['value' => $value]);
    }

    public function deleteMetaByKey($key, $lang = 'en')
    {
        return $this->meta()->where('locale', $lang)->where('key', $key)->delete();
    }
}
