<?php

/**
 * Class Post.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */

namespace  App\Models\Post;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Post.
 *
 * @version 1.0.0
 *
 * @author Rawbinn Shrestha <contact@rawbinn.com>
 * @organization RAWBINN.COM.
 */
class PostMeta extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    protected $fillable = ['key', 'value', 'locale', 'sort'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'post_meta';
    }

    public function pull($key, $default = null)
    {
        $meta = json_decode($this->value, true) ?? [];
        if ($key == 'cols') {
            return count($meta);
        } elseif ($key == 'column') {
            return 12 / count($meta);
        } elseif ($key == 'post') {
            return $meta;
        }
        return $default;
    }
}
