<?php
namespace App\Models\Menu;

use App\Services\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Contracts\Translatable as TranslatableContract;
use Astrotomic\Translatable\Translatable;

/**
 * Class Menu
 * @package Rawbinn\Larapress\Models
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class MenuItem extends Model implements TranslatableContract
{
	use Translatable;
    use Sluggable;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    
	public $translatedAttributes = ['title'];

    
    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'menuitems';
    }

    public function sluggable() : array
    {
		return [
			'source' => 'title',
		];
	}

    /**
     * Return the parent menu.
     */
    public function parent()
    {
        return $this->belongsTo('App\Models\Menu\MenuItem', 'parent_id');
    }

    /**
     * Return the child menu.
     */
    public function children()
    {
        return $this->hasMany('App\Models\Menu\MenuItem', 'parent_id')->orderBy('sort','asc');
    }
}
