<?php
namespace App\Models\Menu;

use App\Services\Sluggable;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Menu
 * @package Rawbinn\Larapress\Models
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class Menu extends Model
{
    use Sluggable;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    
    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'menus';
    }

    public function sluggable() : array
    {
		return [
			'source' => 'title',
		];
	}
}
