<?php

namespace App\Models\Gallery;

use DB;

/**
 * Class GalleryItemAttributes
 * @package App\Models\Gallery
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
trait GalleryItemAttributes
{

    public function getImageAttribute()
    {
        $image = DB::table(config('lfm.table'))->where('id', $this->image_id)->first();
        if($image)
            return public_asset($image->path);

        return '';
    }


    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        return '<a href="' . route('admin.gallery.item.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil-alt" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.edit') . '"></i></a> ';
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        return '<a href="' . route('admin.gallery.item.delete', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="' . trans('buttons.general.cancel') . '"
                 data-trans-button-confirm="' . trans('buttons.general.crud.delete') . '"
                 data-trans-title="' . trans('strings.backend.general.are_you_sure') . '"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.general.crud.delete') . '"></i></a> ';

    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return
        $this->getEditButtonAttribute() .
        $this->getDeleteButtonAttribute();
    }
}
