<?php
namespace App\Models\Gallery;

/**
 * Class GalleryItem
 * @package App\Models\Gallery;
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use DB;
use Illuminate\Database\Eloquent\Model;
use Rawbinn\Media\Models\Media;

class GalleryItem extends Model
{

    use GalleryItemAttributes;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'gallery_items';
    }

    public function media()
    {
        return $this->belongsTo(Media::class, 'image_id');
    }

    public function gallery()
    {
        return $this->belongsTo(Gallery::class);
    }
}
