<?php
namespace App\Models\Gallery;

/**
 * Class Gallery
 * @package App\Models\Gallery
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 * @date 12/20/16
 * @time 8:08 PM
 */

use App\Services\Sluggable;
use Illuminate\Database\Eloquent\Model;
use App\Models\Gallery\GalleryAttributes;

class Gallery extends Model
{

    use GalleryAttributes, Sluggable;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];
    

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'gallery';
    }

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable() : array
    {
        return [
            'source' => 'title',
        ];
    }
    
    public function items()
    {
        return $this->hasMany(GalleryItem::class, 'gallery_id', 'id');
    }
}
