<?php

namespace App\Models\Comment;

use App\Models\Post\Post;
use App\Models\Access\User\User;
use Illuminate\Database\Eloquent\Model;
use App\Models\Comment\CommentAttribute;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Comment
 * @package App\Models\Comment
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class Comment extends Model
{
    use CommentAttribute, SoftDeletes;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * @var array
     */
    protected $dates = ['deleted_at'];


    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = 'comments';
    }

    public function blog()
    {
        return $this->belongsTo(Blog::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function childs()
    {
        return $this->hasMany(Comment::class, 'parent', 'id');
    }
}
