<?php
 
namespace App\Listeners\Backend;
 
use Spatie\Sitemap\Sitemap;
use App\Events\Backend\Blog\BlogCreated;
use App\Models\Post\Post;
use Carbon\Carbon;
use Spatie\Sitemap\Tags\Url;

class SitemapGenerate
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }
 
    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle()
    {
        Sitemap::create()
        ->add(Url::create('/')
        ->setLastModificationDate(Carbon::yesterday())
        ->setChangeFrequency(Url::CHANGE_FREQUENCY_MONTHLY))
        ->add(Post::whereIn('type', ['post', 'page'])->active()->get())
        ->writeToFile(public_path('sitemap.xml'));
    }
}