<?php

namespace App\Http\Requests\Backend\Page;

use App\Http\Requests\Request;

/**
 * Class UpdatePageRequest
 * @package App\Http\Requests\Backend\Page
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class UpdatePageRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->user()->hasPermission('edit-pages');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $locale = $this->lang ?? app()->getLocale();
        return [
            $locale.'.title' => 'required|max:191',
            'slug' => 'required'
        ];
    }
}
