<?php

namespace App\Http\Controllers\Frontend\Auth;

use Theme;
use App\Events\Frontend\Auth\UserRegistered;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Requests\Frontend\Auth\RegisterRequest;
use App\Http\Controllers\Frontend\FrontendController;

/**
 * Class RegisterController
 * @package App\Http\Controllers\Frontend\Auth
 */
class RegisterController extends FrontendController
{
    use RegistersUsers;

	public function __construct()
	{
		// Where to redirect users after registering
		// $this->redirectTo = route('customer.dashboard');
		parent::__construct();
	}

	/**
	 * Show the application registration form.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function showRegistrationForm()
	{
		return Theme::view('auth.register');
	}

	/**
	 * @param RegisterRequest $request
	 * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
	 */
	public function register(RegisterRequest $request)
	{
		if (config('access.users.confirm_email')) {
			// $user = $this->customer->create($request->all());
			event(new UserRegistered($user));
			// return redirect($this->redirectPath())->withFlashSuccess(trans('exceptions.frontend.auth.confirmation.created_confirm'));
		} else {
			// auth()->login($this->customer->create($request->all()));
			event(new UserRegistered(access()->user()));
			return redirect($this->redirectPath());
		}
	}
}