<?php

namespace App\Http\Controllers\Backend;

use View;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Repositories\Backend\TagRepository;

/**
 * Class TagController
 * @package App\Http\Controllers\Backend
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class TagController extends BaseController
{

	/**
     * @var TagRepository
     */
    protected $tag;

    /**
     * @param TagRepository $tag
     */
    public function __construct(TagRepository $tag)
    {
        $this->tag = $tag;
    }

    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //
    }

    /**
     * Returns form view to create tag and also it displays all tag.
     * @param NUll
     * @return mixed
     */
    public function create()
    {
        $tags = $this->tag->getPaginated(10); 
    	return view($this->theme('tag.create'), compact('tags'));
    }

    /**
     * Store tag and redirect back to same page.
     * @param Request $request
     * @return mixed
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required'
        ]);
    	$this->tag->create($request->all());
        return redirect()->back()->withFlashSuccess(trans('alerts.backend.general.created',['attribute' => 'tag']));
    }

    /**
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \Throwable
     */
    public function edit($id)
    {
        $tag = $this->tag->find($id);
        return response()->json(view($this->theme('tag.edit'), compact('tag'))->render());
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\GeneralException
     */
    public function update(Request $request)
    {
        $this->validate($request, [
            'id' => 'required',
        ]);
        $tag = $this->tag->find($request->id);
        $this->tag->update($tag, $request->all());
        return response()->json(true);
    }

    public function delete(Request $request)
    {
        $this->validate($request, [
            'id' => 'required',
        ]);
        try{
            $tag = $this->tag->find($request->id);
            $this->tag->delete($tag);
        }
        catch(\Exception $e){
            return response()->json(['status'=>false]);
        }
        return response()->json(['status'=>true]);
    }

    public function search(Request $request)
    {
        $tags = $this->tag->search($request->q);
        if($tags){
            return response()->json([
                'status' => true,
                'data' => $tags
            ]);
        }
        return response()->json([
            'status' => false,
            'data' => []
        ]);
    }

   
}