<?php

namespace App\Http\Controllers\Backend;

use Analytics;
use App\Models\Comment\Comment;
use App\Models\Post\Post;
use Illuminate\Support\Facades\Artisan;
use Spatie\Analytics\Period;
use Illuminate\Support\Facades\File;
use Rawbinn\Larapress\Facades\Larapress;

/**
 * Class DashboardController.
 *
 * @author Rawbinn Shrestha <rawbinnn@gmail.com>
 */
class DashboardController extends BaseController
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        if(auth()->user()->hasRole(3)) {
            $total_blogs = Post::where('type', 'post')->where('user_id', auth()->id())->count();
        } else {
            $total_blogs = Post::where('type', 'post')->count();
        }
        $total_pages = Post::where('type', 'page')->count();
        $total_comments = Comment::count();
        $total_visitors = 1;
        return view($this->theme('dashboard'), compact('total_pages', 'total_blogs', 'total_comments', 'total_visitors'));
    }

    public function editPost($id)
    {
        $post = Post::findorfail($id);
        if ($post->type == 'page') {
            return redirect()->route('admin.page.edit', $post->id);
        }

        return redirect()->route('admin.blog.edit', $post->id);
    }

    public function analytics()
    {
        $analyticsData = Analytics::fetchTotalVisitorsAndPageViews(Period::days(30));
        $total_page_views = 0;
        $total_visitors = 0;
        foreach ($analyticsData as $data) {
            $total_page_views += $data['pageViews'];
            $total_visitors += $data['visitors'];
        }

        return response()->json([
            'total_page_views' => $total_page_views,
            'total_visitors' => $total_visitors,
        ]);
    }

    public function storageLink()
    {
        Artisan::call('cache:clear');
        if(strpos(realpath(public_path('storage')), 'public\storage') !== false) {
            if(File::exists(public_path('storage'))) {
                File::deleteDirectory(public_path('storage'));
            }
        }
        
        Artisan::call('storage:link');
        echo 'Storage linked successfully.';
    }
}
